// Copyright 1992 by Jon Dart.  All Rights Reserved.

#ifndef _SCORING_H
#define _SCORING_H

#include "board.h"

class Scoring
{
	// This class does static evaluation of chess positions.

	public:
		
	static void init();
		
	static int evalu8( const Board &board );
	// evaluates "board" from the perspective of the side to move.
		
	static int positional_score( const Board &board );
	// returns a positional score

	static int material_score( const Board &board );
	// returns a material score
		
	static BOOL check_en_prise( const Board &board, const ColorType attackingSide,
        const Piece p, const Square sq);
	// return "True" if a piece p is unsafe on square "sq".
	
	static int en_prise;
	// set by calls to positional_score or evalu8; count of
	// apparently en prise pieces
		
	static int trapped;
	// set by calls to positional_score or evalu8; true if
	// any piece appears trapped.
		
        static BOOL in_endgame( const Board &board, const ColorType side );
protected:
        static int positional_score( const Board &, const ColorType );

};

#endif
